// FunctionSettings - Manage global settings
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_FUNCTIONS_FUNCTIONSETTINGS_H
#define FBUILD_FUNCTIONS_FUNCTIONSETTINGS_H

// Includes
//------------------------------------------------------------------------------
#include "Function.h"
#include <Core/Containers/Array.h>
#include <Core/Strings/AString.h>

// FunctionSettings
//------------------------------------------------------------------------------
class FunctionSettings : public Function
{
public:
	explicit		FunctionSettings();
	inline virtual ~FunctionSettings() {}

protected:
	virtual bool IsUnique() const;
	virtual bool Commit( const BFFIterator & funcStartIter ) const;

private:
	void ProcessEnvironment( const Array< AString > & envStrings ) const;
};

//------------------------------------------------------------------------------
#endif // FBUILD_FUNCTIONS_FUNCTIONSETTINGS_H
