// FunctionSettings
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "FunctionSettings.h"
#include <Tools/FBuild/FBuildCore/FBuild.h>
#include <Tools/FBuild/FBuildCore/Flog.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFIterator.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFStackFrame.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFVariable.h>

#include <Core/Containers/AutoPtr.h>

// CONSTRUCTOR
//------------------------------------------------------------------------------
FunctionSettings::FunctionSettings()
: Function( "Settings" )
{
}

// IsUnique
//------------------------------------------------------------------------------
/*virtual*/ bool FunctionSettings::IsUnique() const
{
	return true;
}

// Commit
//------------------------------------------------------------------------------
/*virtual*/ bool FunctionSettings::Commit( const BFFIterator & funcStartIter ) const
{
	(void)funcStartIter;

	// "CachePath"
	const BFFVariable * cachePath = BFFStackFrame::GetVar( ".CachePath" );
	if ( cachePath )
	{
		ASSERT( FBuild::Get().GetCachePath().IsEmpty() );
		FBuild::Get().SetCachePath( cachePath->GetValue() );
		FLOG_INFO( "CachePath: %s", cachePath->GetValue() );
	}

	// "Workers"
	const BFFVariable * workers = BFFStackFrame::GetVar( ".Workers" );
	if ( workers )
	{
		// for convenience, handle a single string or an array
		if ( workers->IsArray() )
		{
			FBuild::Get().SetWorkerList( workers->GetArray() );
		}
		else
		{
			Array< AString > workerList( 1, false );
			workerList.Append( workers->GetValue() );
			FBuild::Get().SetWorkerList( workerList );
		}
	}

	// "Environment"
	const BFFVariable * env = BFFStackFrame::GetVar( ".Environment" );
	if ( env )
	{
		// for convenience, handle a single string or an array
		if ( env->IsArray() )
		{
			ProcessEnvironment( env->GetArray() );
		}
		else
		{
			Array< AString > envList( 1, false );
			envList.Append( env->GetValue() );
			ProcessEnvironment( envList );
		}
	}

	return true;
}

// ProcessEnvironment
//------------------------------------------------------------------------------
void FunctionSettings::ProcessEnvironment( const Array< AString > & envStrings ) const
{
	// the environment string is used in windows as a double-null terminated string
	// so convert our array to a single buffer

	// work out space required
	uint32_t size = 0;
	for ( uint32_t i=0; i<envStrings.GetSize(); ++i )
	{
		size += envStrings[ i ].GetLength() + 1; // string len inc null
	}

	// allocate space
	AutoPtr< char > envString( new char[ size + 1 ] ); // +1 for extra double-null

	// copy strings end to end
	char * dst = envString.Get();
	for ( uint32_t i=0; i<envStrings.GetSize(); ++i )
	{
		const uint32_t thisStringLen = envStrings[ i ].GetLength();
		AString::Copy( envStrings[ i ].Get(), dst, thisStringLen );
		dst += ( thisStringLen + 1 );
	}

	// final double-null
	*dst = '\000';

	FBuild::Get().SetEnvironmentString( envString.Get(), size );
}

//------------------------------------------------------------------------------
