// FunctionExecutable
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_FUNCTIONS_FUNCTIONEXECUTABLE_H
#define FBUILD_FUNCTIONS_FUNCTIONEXECUTABLE_H

// Includes
//------------------------------------------------------------------------------
#include "Function.h"

#include <Core/Containers/Array.h>

// Fwd Declarations
//------------------------------------------------------------------------------
class AString;
class Node;

// FunctionExecutable
//------------------------------------------------------------------------------
class FunctionExecutable : public Function
{
public:
	explicit		FunctionExecutable();
	inline virtual ~FunctionExecutable() {}

protected:
	virtual bool AcceptsHeader() const;
	virtual bool Commit( const BFFIterator & funcStartIter ) const;
private:
	// recursively process nodes to depend on
	bool DependOnNode( const BFFIterator & iter, const AString & nodeName, Array< Node * > & nodes ) const;
	bool DependOnNode( const BFFIterator & iter, Node * node, Array< Node * > & nodes ) const;
};

//------------------------------------------------------------------------------
#endif // FBUILD_FUNCTIONS_FUNCTIONEXECUTABLE_H
