// FunctionAlias
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "FunctionCopy.h"
#include <Tools/FBuild/FBuildCore/FBuild.h>
#include <Tools/FBuild/FBuildCore/Flog.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFStackFrame.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFVariable.h>
#include <Tools/FBuild/FBuildCore/Graph/CopyNode.h>
#include <Tools/FBuild/FBuildCore/Graph/NodeGraph.h>

// CONSTRUCTOR
//------------------------------------------------------------------------------
FunctionCopy::FunctionCopy()
: Function( "Copy" )
{
}

// AcceptsHeader
//------------------------------------------------------------------------------
/*virtual*/ bool FunctionCopy::AcceptsHeader() const
{
	return true;
}

// Commit
//------------------------------------------------------------------------------
/*virtual*/ bool FunctionCopy::Commit( const BFFIterator & funcStartIter ) const
{
	// make sure all required variables are defined
	const BFFVariable * srcFileV;
	const BFFVariable * dstFileV;
	if ( !GetString( funcStartIter, srcFileV, ".Source", true ) ||
		 !GetString( funcStartIter, dstFileV, ".Dest", true ) )
	{
		return false; // GetString will have emitted errors
	}

	// some path cleanup
	AStackString<> srcFile;
	AStackString<> dstFile;
	NodeGraph::CleanPath( srcFileV->GetValue(), srcFile );
	NodeGraph::CleanPath( dstFileV->GetValue(), dstFile );

	// source must be a file, not a  path
	if ( srcFile.EndsWith( '\\' ) )
	{
		Error::Error_1105_PathNotAllowed( funcStartIter, this, ".Source", srcFile );
		return false;
	}

	// dest can be a file OR a path.  If it's a path, use the source filename part
	if ( dstFile.EndsWith( '\\' ) )
	{
		// find filename part of source
		const char * lastSlash = srcFile.FindLast( '\\' );
		dstFile += lastSlash ? ( lastSlash + 1 )	// append filename part if found
							 : srcFile.Get();		// otherwise append whole thing
	}

	// get source node
	NodeGraph & ng = FBuild::Get().GetDependencyGraph();
	Node * srcNode = ng.FindNode( srcFile );
	if ( srcNode )
	{
		if ( srcNode->IsAFile() == false )
		{
			Error::Error_1103_NotAFile( funcStartIter, this, ".Source", srcFile, srcNode->GetType() );
			return false;
		}
	}
	else
	{
		// source file not defined by use - assume an external file
		srcNode = ng.CreateFileNode( srcFile );
	}

	// check node doesn't already exist
	if ( ng.FindNode( dstFile ) )
	{
		Error::Error_1100_AlreadyDefined( funcStartIter, this, dstFile );
		return false;
	}

	// create our node
	Node * copyNode = ng.CreateCopyNode( dstFile, srcNode );

	// handle alias creation
	return ProcessAlias( funcStartIter, copyNode );
}

//------------------------------------------------------------------------------
