// FunctionAlias
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "FunctionAlias.h"
#include <Tools/FBuild/FBuildCore/FBuild.h>
#include <Tools/FBuild/FBuildCore/Flog.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFStackFrame.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFVariable.h>
#include <Tools/FBuild/FBuildCore/Graph/NodeGraph.h>

// CONSTRUCTOR
//------------------------------------------------------------------------------
FunctionAlias::FunctionAlias()
: Function( "Alias" )
{
}

// AcceptsHeader
//------------------------------------------------------------------------------
/*virtual*/ bool FunctionAlias::AcceptsHeader() const
{
	return true;
}

// NeedsHeader
//------------------------------------------------------------------------------
/*virtual*/ bool FunctionAlias::NeedsHeader() const
{
	return true;
}

// Commit
//------------------------------------------------------------------------------
/*virtual*/ bool FunctionAlias::Commit( const BFFIterator & funcStartIter ) const
{
	// make sure all required variables are defined

	// need a list of real targets
	const BFFVariable * targets = BFFStackFrame::GetVar( ".Targets" );
	if ( targets == nullptr )
	{
		Error::Error_1101_MissingProperty( funcStartIter, this, AStackString<>( "Targets" ) );
		return false;
	}

	Array< AString > targetNames;

	// list of targets must be an array
	if ( targets->IsArray() )
	{
		for ( Array< AString >::Iter iter = targets->GetArray().Begin();
			  iter != targets->GetArray().End();
			  iter++ )
		{
			targetNames.Append( *iter );
		}
	}
	else if ( targets->IsString() )
	{
		targetNames.Append( targets->GetValue() );
	}
	else
	{
		Error::Error_1050_PropertyMustBeOfType( funcStartIter, this, "Targets", targets->GetType(), BFFVariable::VAR_STRING, BFFVariable::VAR_ARRAY );
		return false;
	}

	if ( targetNames.IsEmpty() )
	{
		Error::Error_1004_EmptyStringPropertyNotAllowed( funcStartIter, this, "Targets" );
		return false;
	}

	NodeGraph & ng = FBuild::Get().GetDependencyGraph();

	// convert targets to nodes
	Array< Node * > targetNodes( targets->GetArray().GetSize(), false );
	for ( Array< AString >::Iter iter = targetNames.Begin();
		  iter != targetNames.End();
		  iter++ )
	{
		Node * n = ng.FindNode( *iter );
		if ( n )
		{
			targetNodes.Append( n );
		}
		else
		{
			Error::Error_1104_TargetNotDefined( funcStartIter, this, "Targets", *iter );
			return false;
		}
	}

	if ( ng.FindNode( m_AliasForFunction ) != nullptr )
	{
		Error::Error_1100_AlreadyDefined( funcStartIter, this, m_AliasForFunction );
		return false;
	}

	ng.CreateAliasNode( m_AliasForFunction, targetNodes );

	return true;
}

//------------------------------------------------------------------------------
