// Function
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_FUNCTIONS_FUNCTION_H
#define FBUILD_FUNCTIONS_FUNCTION_H

// includes
//------------------------------------------------------------------------------
#include <Core/Containers/Array.h>
#include <Core/Strings/AString.h>
#include <Tools/FBuild/FBuildCore/Error.h>

// Forward Declarations
//------------------------------------------------------------------------------
class BFFIterator;
class BFFVariable;
class Node;

// Function
//------------------------------------------------------------------------------
class Function
{
public:
	explicit	Function( const char * functionName );
	virtual		~Function();

	// info about a function
	inline const AString & GetName() const { return m_Name; }

	// access to functions
	static const Function * Find( const AString & name );

	static void Create();
	static void Destroy();

	// does this function support a header? i.e. FunctionName( ...header.... )
	virtual bool AcceptsHeader() const; // can have a header
	virtual bool NeedsHeader() const;	// must have a header

	// must this function be unique?
	virtual bool IsUnique() const;
	inline bool GetSeen() const { return m_Seen; }
	inline void SetSeen() const { m_Seen = true; }

	// most functions don't need to override this
	virtual bool ParseFunction( const BFFIterator & functionNameStart,
								const BFFIterator & functionBodyStartToken, 
								const BFFIterator & functionBodyStopToken,
								const BFFIterator * functionHeaderStartToken,
								const BFFIterator * functionHeaderStopToken ) const;

	// most functions will override this to commit the effects of the function
	virtual bool Commit( const BFFIterator & funcStartIter ) const;

private:
	Function *	m_NextFunction;
	static Function * s_FirstFunction;

protected:
	AString		m_Name;
	mutable bool m_Seen; // track for unique enforcement

	// for functions that support a simple alias parameter, the base class can
	// parse it out
	mutable AString m_AliasForFunction;

	bool GetString( const BFFIterator & iter, const BFFVariable * & var, const char * name, bool required = false ) const;
	bool GetBool( const BFFIterator & iter, bool & var, const char * name, bool defaultValue, bool required = false ) const;
	bool GetNodeList( const BFFIterator & iter, const char * name, Array< Node * > & nodes, bool required = false ) const;

	// helper function to make alias for target
	bool ProcessAlias( const BFFIterator & iter, Node * nodeToAlias ) const;
private:
	bool GetNodeListRecurse( const BFFIterator & iter, const char * name, Array< Node * > & nodes, const AString & nodeName ) const;
};

//------------------------------------------------------------------------------
#endif // FBUILD_FUNCTIONS_FUNCTION_H
