// BFFVariable - a single variable in a BFFStack
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_VARIABLE_H
#define FBUILD_VARIABLE_H

// Includes
//------------------------------------------------------------------------------
#include <Core/Containers/Array.h>
#include <Core/Strings/AString.h>

// Forward Declarations
//------------------------------------------------------------------------------

// BFFVariable
//------------------------------------------------------------------------------
class BFFVariable
{
public:
	inline const AString & GetName() const { return m_Name; }

	const AString & GetValue() const { return m_StringValue; }
	const Array< AString > & GetArray() const { return m_ArrayValues; }
	int GetInt() const { return m_IntValue; }
	bool GetBool() const { return m_BoolValue; }

	enum VarType
	{
		VAR_ANY		= 0, // used for searching
		VAR_STRING	= 1,
		VAR_BOOL	= 2,
		VAR_ARRAY	= 3,
		VAR_INT		= 4,
		MAX_VAR_TYPES	 // NOTE: Be sure to update s_TypeNames when adding to here
	};

	inline VarType GetType() const	{ return m_Type; }
	inline static const char * GetTypeName( VarType t ) { return s_TypeNames[ (uint32_t)t ]; }

	inline bool IsString() const	{ return m_Type == BFFVariable::VAR_STRING; }
	inline bool IsBool() const		{ return m_Type == BFFVariable::VAR_BOOL; }
	inline bool IsArray() const		{ return m_Type == BFFVariable::VAR_ARRAY; }
	inline bool IsInt() const		{ return m_Type == BFFVariable::VAR_INT; }

private:
	friend class BFFStackFrame;

	explicit BFFVariable( const AString & name, const AString & value );
	explicit BFFVariable( const AString & name, bool value );
	explicit BFFVariable( const AString & name, const Array< AString > & values );
	explicit BFFVariable( const AString & name, int i );
	~BFFVariable();

	void SetValue( const AString & value );
	void SetValue( bool value );
	void SetValue( const Array< AString > & values );
	void SetValue( int i );

	AString m_Name;

	//
	VarType				m_Type;
	AString				m_StringValue;
	bool				m_BoolValue;
	Array< AString >	m_ArrayValues;
	int					m_IntValue;

	static const char * s_TypeNames[ MAX_VAR_TYPES ];
};

//------------------------------------------------------------------------------
#endif // FBUILD_VARIABLE_H
 