// BFFVariable
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "BFFVariable.h"


// Static Data
//------------------------------------------------------------------------------
/*static*/ const char * BFFVariable::s_TypeNames[] =
{
	"Any",
	"String",
	"Bool",
	"Array",
	"Int"
};

// CONSTRUCTOR
//------------------------------------------------------------------------------
BFFVariable::BFFVariable( const AString & name, const AString & value )
: m_Name( name )
, m_Type( VAR_STRING )
, m_StringValue( value )
, m_BoolValue( false )
, m_ArrayValues( 0, false )
, m_IntValue( 0 )
{
}

// CONSTRUCTOR
//------------------------------------------------------------------------------
BFFVariable::BFFVariable( const AString & name, bool value )
: m_Name( name )
, m_Type( VAR_BOOL )
//, m_StringValue() // default construct this
, m_BoolValue( value )
, m_ArrayValues( 0, false )
, m_IntValue( 0 )
{
}

// CONSTRUCTOR
//------------------------------------------------------------------------------
BFFVariable::BFFVariable( const AString & name, const Array< AString > & values )
: m_Name( name )
, m_Type( VAR_ARRAY )
//, m_StringValue() // default construct this
, m_BoolValue( false )
, m_ArrayValues( 0, true )
, m_IntValue( 0 )
{
	m_ArrayValues = values;
}

// CONSTRUCTOR
//------------------------------------------------------------------------------
BFFVariable::BFFVariable( const AString & name, int i )
: m_Name( name )
, m_Type( VAR_INT )
//, m_StringValue() // default construct this
, m_BoolValue( false )
, m_ArrayValues( 0, true )
, m_IntValue( i )
{
}

// DESTRUCTOR
//------------------------------------------------------------------------------
BFFVariable::~BFFVariable()
{
}

// SetValue
//------------------------------------------------------------------------------
void BFFVariable::SetValue( const AString & value )
{
	m_Type = VAR_STRING;
	m_StringValue = value;
}

// SetValue (bool)
//------------------------------------------------------------------------------
void BFFVariable::SetValue( bool value )
{
	m_Type = VAR_BOOL;
	m_BoolValue = value;
}

// SetValue (array)
//------------------------------------------------------------------------------
void BFFVariable::SetValue( const Array< AString > & values )
{
	m_Type = VAR_ARRAY;
	m_ArrayValues = values;
}

// SetValue (int)
//------------------------------------------------------------------------------
void BFFVariable::SetValue( int i )
{
	m_Type = VAR_INT;
	m_IntValue = i;
}
//------------------------------------------------------------------------------
