// Timer.h
//------------------------------------------------------------------------------
#pragma once
#ifndef CORE_TIME_TIMER_H
#define CORE_TIME_TIMER_H

// Includes
//------------------------------------------------------------------------------
#include <Core/Env/Types.h>

// Timer
//------------------------------------------------------------------------------
class Timer
{
public:
	Timer() { Start(); }
	inline ~Timer() {}

	inline void Start() { m_StartTime = GetNow(); }
	inline void Start( float time ) { m_StartTime = GetNow() - (int64_t)( (double)GetFrequency() * (double)time ); }

	float GetElapsed() const
	{
		int64_t now = GetNow();
		return (float)( (double)( now - m_StartTime ) / (double)GetFrequency() );
	}

	static int64_t GetNow();
	static inline int64_t GetFrequency() { return s_Frequency; }

private:
	int64_t m_StartTime;

	// frequency
	friend class GlobalTimerFrequencyInitializer;
	static int64_t s_Frequency;
};

//------------------------------------------------------------------------------
#endif // CORE_TIME_TIMER_H
