// Timer.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "Timer.h"
#include <Core/Env/Assert.h>
#include <Windows.h>

// Static
//------------------------------------------------------------------------------
int64_t Timer::s_Frequency = 0;

// helper to initialize frequency at startup
class GlobalTimerFrequencyInitializer
{
public:
	GlobalTimerFrequencyInitializer()
	{
		ASSERT( Timer::s_Frequency == 0 );
		LARGE_INTEGER freq;
		VERIFY( QueryPerformanceFrequency( &freq ) );
		Timer::s_Frequency = freq.QuadPart;
	}
};
GlobalTimerFrequencyInitializer g_GlobalTimerFrequencyInitializer;

// GetNow
//------------------------------------------------------------------------------
int64_t Timer::GetNow()
{
	ASSERT( s_Frequency );
	LARGE_INTEGER now;
	VERIFY( QueryPerformanceCounter( &now ) );
	return now.QuadPart;
}

//------------------------------------------------------------------------------
