// Thread functionality
//------------------------------------------------------------------------------
#pragma once
#ifndef CORE_THREAD_H
#define CORE_THREAD_H

// Includes
//------------------------------------------------------------------------------
#include <Core/Env/Types.h>

// Thread
//------------------------------------------------------------------------------
class Thread
{
public:
	#if defined( WIN32 ) || defined( WIN64 )
		typedef uint32_t ThreadId;
		typedef void * ThreadHandle;
		typedef uint32_t ThreadEntryFunction( void * param );

		#define INVALID_THREAD_HANDLE ( nullptr )
	#endif

	static ThreadId GetCurrentThreadId();
	static bool IsThread( ThreadId threadId ) { return ( GetCurrentThreadId() == threadId ); }
	static bool IsMainThread() { return GetCurrentThreadId() == s_MainThreadId; }

	static ThreadHandle CreateThread( ThreadEntryFunction entryFunc,
									  const char * threadName = nullptr,
									  uint32_t stackSize = ( 64 * KILOBYTE ),
									  void * userData = nullptr
									);
private:
	static ThreadId s_MainThreadId;
};

//------------------------------------------------------------------------------
#endif // CORE_THREAD_H
