// Thread
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "Thread.h"
#include <Core/Env/Assert.h>

#include <windows.h>

// Debug Structure for thread name setting
//------------------------------------------------------------------------------
#ifdef DEBUG
	#pragma pack(push,8)
	typedef struct tagTHREADNAME_INFO
	{
	   DWORD dwType; // Must be 0x1000.
	   LPCSTR szName; // Pointer to name (in user addr space).
	   DWORD dwThreadID; // Thread ID (-1=caller thread).
	   DWORD dwFlags; // Reserved for future use, must be zero.
	} THREADNAME_INFO;
	#pragma pack(pop)
#endif

// Static Data
//------------------------------------------------------------------------------
/*static*/ Thread::ThreadId Thread::s_MainThreadId( Thread::GetCurrentThreadId() );

// GetCurrentThreadId
//------------------------------------------------------------------------------
/*static*/ Thread::ThreadId Thread::GetCurrentThreadId()
{
	#ifdef WIN32
		return (Thread::ThreadId) ::GetCurrentThreadId();
	#endif
}

// CreateThread
//------------------------------------------------------------------------------
#pragma warning( push )
#pragma warning( disable : 28021 ) // The parameter '_Param_(4)' being annotated with 'aliases memory' must be a pointer.
/*static*/ Thread::ThreadHandle Thread::CreateThread( ThreadEntryFunction entryFunc,
													  const char * threadName,
													  uint32_t stackSize,
													  void * userData )
{
	#ifdef WIN32
		DWORD threadId;
		HANDLE h = ::CreateThread( nullptr,		// LPSECURITY_ATTRIBUTES lpThreadAttributes
								 stackSize,		// SIZE_T dwStackSize
								 (LPTHREAD_START_ROUTINE)entryFunc,	// LPTHREAD_START_ROUTINE lpStartAddress
								 userData,		// LPVOID lpParameter
								 0,				// DWORD dwCreationFlags
								 (LPDWORD)&threadId		// LPDWORD lpThreadId
							   );
		ASSERT( h != nullptr );

		// set thread name to assist debugging
		#ifdef DEBUG
			if ( threadName )
			{
				const DWORD MS_VC_EXCEPTION=0x406D1388;

				THREADNAME_INFO info;
				info.dwType = 0x1000;
				info.szName = threadName;
				info.dwThreadID = threadId;
				info.dwFlags = 0;

				__try
				{
					RaiseException( MS_VC_EXCEPTION, 0, sizeof(info)/sizeof(ULONG_PTR), (ULONG_PTR*)&info );
				}
				__except(EXCEPTION_EXECUTE_HANDLER)
				{
				}
			}
		#else
			(void)threadName;
			(void)threadId;
		#endif
	
		return h;
	#endif
}
#pragma warning( pop )

//------------------------------------------------------------------------------
