// Process.h
//------------------------------------------------------------------------------
#pragma once
#ifndef CORE_PROCESS_H
#define CORE_PROCESS_H

// Includes
//------------------------------------------------------------------------------
#include <Core/Env/Types.h>
#include <Core/Containers/AutoPtr.h>

// Process
//------------------------------------------------------------------------------
class Process
{
public:
	Process();
	~Process();

	bool Spawn( const char * executable,
				const char * args,
				const char * workingDir,
				const char * environment );
	bool IsRunning() const;
	int WaitForExit();

	// Read all data from the process until it exits
	// NOTE: Owner must free the returned memory!
	void ReadAllData( AutoPtr< char > & memOut, uint32_t * memOutSize,
					  AutoPtr< char > & errOut, uint32_t * errOutSize );

	// Read all available data
	// NOTE: Owner must free the returned memory!
	char * ReadStdOut( uint32_t * bytesRead = nullptr );
	char * ReadStdErr( uint32_t * bytesRead = nullptr );

	// read available data into a limited user buffer
	uint32_t ReadStdOut( char * outputBuffer, uint32_t outputBufferSize );
	uint32_t ReadStdErr( char * outputBuffer, uint32_t outputBufferSize );

private:
	void Read( void * handle, AutoPtr< char > & buffer, uint32_t & sizeSoFar, uint32_t & bufferSize );
	char * Read( void * handle, uint32_t * bytesRead );
	uint32_t Read( void * handle, char * outputBuffer, uint32_t outputBufferSize );

	// This messyness is to avoid including windows.h in this file
	inline struct _PROCESS_INFORMATION & GetProcessInfo() const
	{ 
		return (_PROCESS_INFORMATION &)m_ProcessInfo;
	}
	#if defined ( WIN64 )
		unsigned char m_ProcessInfo[ 8 + 8 + 4 + 4 ]; // PROCESS_INFORMATION
	#elif defined ( WIN32 )
		unsigned char m_ProcessInfo[ 4 + 4 + 4 + 4 ]; // PROCESS_INFORMATION
	#endif
	//void * m_StdInRead;	// HANDLE
	//void * m_StdInWrite;	// HANDLE
	void * m_StdOutRead;	// HANDLE
	void * m_StdOutWrite;	// HANDLE
	void * m_StdErrRead;	// HANDLE
	void * m_StdErrWrite;	// HANDLE

	bool m_Started;
};

//------------------------------------------------------------------------------
#endif // CORE_PROCESS_H
