// Mutex
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "Mutex.h"

#include "windows.h"
#include <Core/Env/Assert.h>

// CONSTRUCTOR
//------------------------------------------------------------------------------
Mutex::Mutex()
{ 
	CTASSERT( sizeof( m_CriticalSection ) == sizeof( CRITICAL_SECTION ) );

	VERIFY( InitializeCriticalSectionAndSpinCount( (CRITICAL_SECTION *)&m_CriticalSection, 100 ) );
}

// DESTRUCTOR
//------------------------------------------------------------------------------
Mutex::~Mutex()
{ 
	DeleteCriticalSection( (CRITICAL_SECTION *)&m_CriticalSection );
}

#pragma warning( push )
#pragma warning( disable : 26135 ) // static analysis complains about missing annotation
// Lock
//------------------------------------------------------------------------------
void Mutex::Lock()
{ 
	EnterCriticalSection( (CRITICAL_SECTION *)&m_CriticalSection );
}
// Unlock
//------------------------------------------------------------------------------
void Mutex::Unlock()
{ 
	LeaveCriticalSection( (CRITICAL_SECTION *)&m_CriticalSection );
}
#pragma warning( pop )

//------------------------------------------------------------------------------
