// MemoryStream
//------------------------------------------------------------------------------
#pragma once
#ifndef CORE_FILEIO_MEMORYSTREAM_H
#define CORE_FILEIO_MEMORYSTREAM_H

// Includes
//------------------------------------------------------------------------------
#include "IOStream.h"

// MemoryStream
//------------------------------------------------------------------------------
class MemoryStream : public IOStream
{
public:
	explicit MemoryStream();
	~MemoryStream();

	// memory stream specific functions
	inline const void * GetData() const { return (void *)m_Buffer.Begin(); }
	inline size_t		GetSize() const { return m_Buffer.GetSize(); } 

	// raw read/write functions
	virtual uint64_t ReadBuffer( void * buffer, uint64_t bytesToRead );
	virtual uint64_t WriteBuffer( const void * buffer, uint64_t bytesToWrite );
	virtual void Flush();

	// size/position
	virtual uint64_t Tell() const;
	virtual bool Seek( uint64_t pos ) const;
	virtual uint64_t GetFileSize() const;

private:
	Array< char >	m_Buffer;
	size_t			m_CurrentPos;
};

//------------------------------------------------------------------------------
#endif // CORE_FILEIO_MEMORYSTREAM_H
