// Types.h
//------------------------------------------------------------------------------
#pragma once
#ifndef CORE_ENV_TYPES_H
#define CORE_ENV_TYPES_H

typedef unsigned char		uint8_t;
typedef signed char			int8_t;
typedef unsigned short		uint16_t;
typedef signed short		int16_t;
typedef unsigned int		uint32_t;
typedef signed int			int32_t;
typedef unsigned long long	uint64_t;
typedef signed long long	int64_t;

#define UINT16_MAX (uint16_t(0xFFFF))
#define UINT32_MAX (uint32_t(0xFFFFFFFF))

#define KILOBYTE (1024)
#define MEGABYTE (1024 * 1024)

#define UNUSED( x )

#define THREAD_LOCAL __declspec( thread )

#define NO_INLINE __declspec( noinline )

//------------------------------------------------------------------------------
#endif // CORE_ENV_TYPES_H
