// Env.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "Env.h"

#include <windows.h>
#include <stdio.h>

// GetNumProcessors
//------------------------------------------------------------------------------
/*static*/ uint32_t Env::GetNumProcessors()
{
	// Default to NUMBER_OF_PROCESSORS
	uint32_t numProcessors = 1;
	const uint32_t bufferSize( 32 );
	char buffer[ bufferSize ];
	DWORD ret = GetEnvironmentVariable( "NUMBER_OF_PROCESSORS", buffer, bufferSize );
	if ( ( ret > 0 ) && ( ret < bufferSize ) )
	{
		if ( sscanf_s( buffer, "%u", &numProcessors ) != 1 )
		{
			numProcessors = 1;
		}
	}

	return numProcessors;
}

//------------------------------------------------------------------------------
