// Assert.h
//------------------------------------------------------------------------------
#pragma once
#ifndef CORE_ENV_ASSERT_H
#define CORE_ENV_ASSERT_H

// DEBUG
//------------------------------------------------------------------------------
#ifdef DEBUG
	#define ASSERTS_ENABLED

	// standard assertion macro
	#define ASSERT( expression )												\
		do {																	\
		__pragma(warning(push))													\
		__pragma(warning(disable:4127))											\
			if ( !( expression ) )												\
			{																	\
				if ( AssertHandler::Failure( #expression, __FILE__, __LINE__ ) )\
				{																\
					__debugbreak();												\
				}																\
			}																	\
		} while ( false );														\
		__pragma(warning(pop))

	// assert result of code, but still execute code when asserts are disabled
	#define VERIFY( code ) ASSERT( code )

	// compile time assertion
	#define CTASSERT( expression )												\
		do {																	\
		__pragma(warning(push))													\
		__pragma(warning(disable:4127))											\
			compile_time_assert_failure< ( expression ) > ();					\
		} while ( false );														\
		__pragma(warning(pop))
	template<bool> struct compile_time_assert_failure;
	template<> struct compile_time_assert_failure<true>{};

	class AssertHandler
	{
	public:
		static void SetThrowOnAssert( bool throwOnAssert )
		{
			s_ThrowOnAssert = throwOnAssert;
		}
		static bool Failure( const char * message, 
							 const char * file,  
							 const int line );

		static bool s_ThrowOnAssert;
	};

// RELEASE
//------------------------------------------------------------------------------
#elif defined ( RELEASE )
	#define ASSERT( expression )			\
		do {								\
		__pragma(warning(push))				\
		__pragma(warning(disable:4127))		\
		} while ( false );					\
		__pragma(warning(pop))

	#define VERIFY( code )					\
		do {								\
			if ( code ) {}					\
		__pragma(warning(push))				\
		__pragma(warning(disable:4127))		\
		} while ( false );					\
		__pragma(warning(pop))

	#define CTASSERT( expression )			\
		do {								\
		__pragma(warning(push))				\
		__pragma(warning(disable:4127))		\
		} while ( false );					\
		__pragma(warning(pop))

#else
	#error neither DEBUG nor RELEASE were defined
#endif

//------------------------------------------------------------------------------
#endif // CORE_ENV_ASSERT_H
